/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets.to_client;

import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.network.packets.IPEPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public class SyncEmcPKT
implements IPEPacket {
    private final EmcPKTInfo[] data;

    public SyncEmcPKT(EmcPKTInfo[] data) {
        this.data = data;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        PECore.LOGGER.info("Receiving EMC data from server.");
        EMCMappingHandler.fromPacket(this.data);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.data.length);
        for (EmcPKTInfo info : this.data) {
            buffer.writeRegistryId((IForgeRegistryEntry)info.item);
            buffer.m_130079_(info.nbt());
            buffer.m_130103_(info.emc());
        }
    }

    public static SyncEmcPKT decode(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        EmcPKTInfo[] data = new EmcPKTInfo[size];
        for (int i = 0; i < size; ++i) {
            data[i] = new EmcPKTInfo((Item)buffer.readRegistryId(), buffer.m_130260_(), buffer.m_130258_());
        }
        return new SyncEmcPKT(data);
    }

    public record EmcPKTInfo(Item item, @Nullable CompoundTag nbt, long emc) {
    }
}

